/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.testscenarios.verifiers;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.drools.base.TypeResolver;
import org.drools.ide.common.client.modeldriven.testing.VerifyField;
import org.drools.ide.common.server.testscenarios.verifiers.ResultVerifier;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;

public class FactFieldValueVerifier {
    private final Map<String, Object> populatedData;
    private final String factName;
    private final Object factObject;
    private VerifyField currentField;
    final TypeResolver resolver;
    private final ParserConfiguration pconf;
    private final ParserContext pctx;

    public FactFieldValueVerifier(Map<String, Object> populatedData, String factName, Object factObject, TypeResolver resolver, ClassLoader classLoader) {
        this.populatedData = populatedData;
        this.factName = factName;
        this.factObject = factObject;
        this.resolver = resolver;
        this.pconf = new ParserConfiguration();
        this.pconf.setClassLoader(classLoader);
        this.pctx = new ParserContext(this.pconf);
        this.pctx.setStrongTyping(true);
    }

    public void checkFields(List<VerifyField> fieldValues) {
        for (VerifyField this.currentField : fieldValues) {
            if (this.currentField.getExpected() == null) continue;
            ResultVerifier resultVerifier = new ResultVerifier(this.factObject);
            resultVerifier.setExpected(this.getExpectedResult());
            this.currentField.setSuccessResult(resultVerifier.isSuccess(this.currentField));
            if (!this.currentField.getSuccessResult().booleanValue()) {
                this.currentField.setActualResult(resultVerifier.getActual(this.currentField));
                this.currentField.setExplanation(this.getFailingExplanation());
                continue;
            }
            this.currentField.setExplanation(this.getSuccessfulExplanation());
        }
    }

    private Object getExpectedResult() {
        Object expectedResult = this.currentField.getExpected().trim();
        if (this.currentField.getExpected().startsWith("=")) {
            expectedResult = MVEL.eval(this.currentField.getExpected().substring(1), this.populatedData);
        } else if (this.currentField.getNature() == 4L) {
            try {
                String classNameOfEnum = this.currentField.getExpected().substring(0, this.currentField.getExpected().indexOf("."));
                String valueOfEnum = this.currentField.getExpected().substring(this.currentField.getExpected().indexOf(".") + 1);
                String fullName = this.resolver.getFullTypeName(classNameOfEnum);
                if (fullName != null && !"".equals(fullName)) {
                    valueOfEnum = fullName + "." + valueOfEnum;
                }
                Serializable compiled = MVEL.compileExpression(valueOfEnum, this.pctx);
                expectedResult = MVEL.executeExpression(compiled);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return expectedResult;
    }

    private String getSuccessfulExplanation() {
        if (this.currentField.getOperator().equals("==")) {
            return "[" + this.factName + "] field [" + this.currentField.getFieldName() + "] was [" + this.currentField.getExpected() + "].";
        }
        if (this.currentField.getOperator().equals("!=")) {
            return "[" + this.factName + "] field [" + this.currentField.getFieldName() + "] was not [" + this.currentField.getExpected() + "].";
        }
        return "";
    }

    private String getFailingExplanation() {
        if (this.currentField.getOperator().equals("==")) {
            return "[" + this.factName + "] field [" + this.currentField.getFieldName() + "] was [" + this.currentField.getActualResult() + "] expected [" + this.currentField.getExpected() + "].";
        }
        return "[" + this.factName + "] field [" + this.currentField.getFieldName() + "] was not expected to be [" + this.currentField.getActualResult() + "].";
    }
}

